﻿// Please see documentation at https://docs.microsoft.com/aspnet/core/client-side/bundling-and-minification
// for details on configuring this project to bundle and minify static web assets.

// Write your JavaScript code.

function showAlertWindow(message, isError) {
    if (isError === false) {
        toastr.success(message, 'Success', { timeOut: 5000 });
        return;
    }

    var alertWindow = $('#alertWindow').data('kendoWindow');

    // Set title and styling based on error state
    if (isError === true) {
        alertWindow.title('Error');
        alertWindow.wrapper.find('.k-window-titlebar').css('background-color', '#dc3545');
    } else {
        alertWindow.title('Error(s) Detected');
        alertWindow.wrapper.find('.k-window-titlebar').css('background-color', '');
    }

    alertWindow.content(message);
    alertWindow.refresh();
    alertWindow.center();
    alertWindow.open();
}
function error_handler(e) {
    if (e.errors) {
        var message = "Errors:\n";
        $.each(e.errors, function (key, value) {
            if ('errors' in value) {
                $.each(value.errors, function () {
                    message += this + "\n";
                });
            }
        });
        showAlertWindow(message);
    }
}

/**
 * Formats an array of indices into a compressed range string.
 * Example: [1, 2, 3, 5, 8, 9] -> "1-3, 5, 8, 9"
 * Sequences of 3 or more are compressed with a dash.
 * Pairs are kept as comma-separated.
 */
function formatIndexRanges(indices) {
    if (!indices || indices.length === 0) return "";

    // Ensure sorted numbers
    var sorted = indices.slice().sort(function (a, b) { return a - b; });
    var ranges = [];
    var start = sorted[0];
    var prev = sorted[0];

    for (var i = 1; i < sorted.length; i++) {
        if (sorted[i] === prev + 1) {
            prev = sorted[i];
        } else {
            if (start === prev) {
                ranges.push(start);
            } else {
                ranges.push(start + "-" + prev);
            }
            start = sorted[i];
            prev = sorted[i];
        }
    }

    // Final range
    if (start === prev) {
        ranges.push(start);
    } else {
        ranges.push(start + "-" + prev);
    }

    return ranges.join(", ");
}
