
function hsv2Rgb(h, s, v) {
    var r, g, b;
    var i;
    var f, p, q, t;

    // ho messo questo perchè per qualche motivo h=1 da un risultato sbagliato (1,0,1 invece di 1,0,0)
    //if (h ==1) h=0;

    // Make sure our arguments stay in-range
    h = Math.max(0, Math.min(1, h)) * 360;
    s = Math.max(0, Math.min(1, s));
    v = Math.max(0, Math.min(1, v));


    if (s == 0) {
        // Achromatic (grey)
        r = g = b = v;
        //return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
        return [r, g, b];
    }

    h /= 60; // sector 0 to 5
    i = Math.floor(h);

    if (i > 5) i = 5;

    f = h - i; // factorial part of h
    p = v * (1 - s);
    q = v * (1 - s * f);
    t = v * (1 - s * (1 - f));

    switch (i) {
        case 0:
            r = v;
            g = t;
            b = p;
            break;

        case 1:
            r = q;
            g = v;
            b = p;
            break;

        case 2:
            r = p;
            g = v;
            b = t;
            break;

        case 3:
            r = p;
            g = q;
            b = v;
            break;

        case 4:
            r = t;
            g = p;
            b = v;
            break;

        default: // case 5:
            r = v;
            g = p;
            b = q;
    }
    return [r, g, b];
}

function rgb2h(r, g, b) {
    let rabs, gabs, babs, rr, gg, bb, h, s, v, diff, diffc, percentRoundFn;
    rabs = r / 255;
    gabs = g / 255;
    babs = b / 255;
    v = Math.max(rabs, gabs, babs),
        diff = v - Math.min(rabs, gabs, babs);
    diffc = c => (v - c) / 6 / diff + 1 / 2;
    percentRoundFn = num => Math.round(num * 100) / 100;
    if (diff == 0) {
        h = s = 0;
    } else {
        s = diff / v;
        rr = diffc(rabs);
        gg = diffc(gabs);
        bb = diffc(babs);

        if (rabs === v) {
            h = bb - gg;
        } else if (gabs === v) {
            h = (1 / 3) + rr - bb;
        } else if (babs === v) {
            h = (2 / 3) + gg - rr;
        }
        if (h < 0) {
            h += 1;
        } else if (h > 1) {
            h -= 1;
        }
    }
    return Math.round(h * 360)
}

function getRandomInt(min = 0, max = 1) {
    min = parseInt(min);
    max = parseInt(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function getRandomReal(min = 0, max = 1) {
    min = parseFloat(min);
    max = parseFloat(max);
    return Math.random() < 0.5 ? ((1 - Math.random()) * (max - min) + min) : (Math.random() * (max - min) + min);
}

/******************* COLOR *******************/

function Color(r, g, b, white) {
    this.r = r;
    this.g = g;
    this.b = b;
    this.white = white;
}

Color.prototype.colorDimmedBy = function (ratio) {
    var inv = 1.0 - Math.max(Math.min(ratio, 1.0), 0.0)
    if (defaultStrip.ledProfileName == "rgbw") {
        return Color.colorWithRedGreenBlueWhite(this.r * inv, this.g * inv, this.b * inv, this.white * inv)
    } else {
        return Color.colorWithRedGreenBlue(this.r * inv, this.g * inv, this.b * inv)
    }
}

Color.prototype.colorByAdding = function (other) {
    return Color.colorWithRedGreenBlue(this.r + other.r, this.g + other.g, this.b + other.b)
}

Color.prototype.colorByMixingRatio = function (other, ratio) {
    var inv = (1 - Math.max(Math.min(ratio, 1.0), 0.0))
    if (defaultStrip.ledProfileName == "rgbw") {
        return Color.colorWithRedGreenBlueWhite(
            this.r * inv + other.r * ratio,
            this.g * inv + other.g * ratio,
            this.b * inv + other.b * ratio,
            this.white * inv + other.white * ratio
        )
    } else {
        return Color.colorWithRedGreenBlue(
            this.r * inv + other.r * ratio,
            this.g * inv + other.g * ratio,
            this.b * inv + other.b * ratio
        )
    }
}

Color.prototype.hue = function () {
    return rgb2h(this.r, this.g, this.b) / 360.0
}

Color.prototype.isBlack = function () {
    return (this.r == 0 && this.g == 0 && this.b == 0 && this.white == 0);
}

Color.colorWithRedGreenBlue = function (r, g, b) {
    return new Color(r, g, b, 0.0);
}

Color.colorWithRedGreenBlueWhite = function (r, g, b, w) {
    return new Color(r, g, b, w);
}

Color.colorWithHexString = function (hex) {

    hex = hex.replace("#", "").replace("0x", "")

    if (hex.length == 8) {
        var r = parseInt(hex.substr(0, 2), 16);
        var g = parseInt(hex.substr(2, 2), 16);
        var b = parseInt(hex.substr(4, 2), 16);
        var white = parseInt(hex.substr(6, 2), 16);

        r /= 255.0, g /= 255.0, b /= 255.0, white /= 255.0;

        return new Color(r, g, b, white);
    }
    else {
        var r = parseInt(hex.substr(0, 2), 16);
        var g = parseInt(hex.substr(2, 2), 16);
        var b = parseInt(hex.substr(4, 2), 16);

        r /= 255.0, g /= 255.0, b /= 255.0;

        return new Color(r, g, b, 0.0);
    }
};

Color.colorWithHueSaturationValue = function (h, s, v) {
    var tmp = hsv2Rgb(h, s, v);
    return new Color(tmp[0], tmp[1], tmp[2], 0.0);
}

Color.colorWithAmberWarmWhiteCoolWhite = function (amber, warmWhite, coolWhite) {
    return new Color(amber, warmWhite, coolWhite, 0.0);
}

Color.colorWithRedBlueWhite = function (red, blue, white) {
    return new Color(red, blue, white, 0.0);
}

Color.blackColor = function () {
    return new Color(0.0, 0.0, 0.0, 0.0);
}

Color.whiteColor = function () {

    if (defaultStrip.ledProfileName == "rgbw") {
        return new Color(0.0, 0.0, 0.0, 1.0);
    }
    else if (defaultStrip.ledProfileName == "rbw") {
        return new Color(0.0, 0.0, 1.0, 0.0);
    } else {
        return new Color(1.0, 1.0, 1.0, 0.0);
    }
}
