
/*
function gammaCorrected(v) {
    return Math.pow(v, 2.5);
}

function inverseGammaCorrected(v) {
    return Math.pow(v, 1.0/2.5);
}
*/

function Frame(size) {
    this.size = size;
    this.colors = [];
    var i;
    for (i = 0; i < size; i++) {
        this.colors[i] = new Color(0.0, 0.0, 0.0, 0.0);
    }
}

Frame.prototype.setColorForLedAtIndex = function (color, index) {
    this.colors[index] = new Color(color.r, color.g, color.b, color.white);
}

Frame.prototype.colorOfLedAtIndex = function (index) {
    return this.colors[index];
}

Frame.prototype.setColorForAllLeds = function (color) {
    var i;
    for (i = 0; i < this.colors.length; i++) {
        this.colors[i] = color;
    }
}

Frame.prototype.setColorsFromBuffer = function (colorsBuffer) {
    var i;
    for (i = 0; i < this.colors.length; i++) {
        this.colors[i] = colorsBuffer[i];
    }
}

Frame.prototype.setColorDimmedByForLedAtIndex = function (color, ratio, index) {
    var inv = 1.0 - Math.max(Math.min(ratio, 1.0), 0.0)
    this.colors[index] = Color.colorWithRedGreenBlue(color.r * inv, color.g * inv, color.b * inv)

    //if (defaultStrip.ledProfileName == "rgbw") {
    this.colors[index].white = color.white * inv
    //}
}

Frame.prototype.setHSVForLedAtIndex = function (h, s, v, index) {
    this.colors[index] = Color.colorWithHueSaturationValue(h, s, v)
}

Frame.frameWithLedCount = function (size) {
    return new Frame(size);
}

Frame.framesWithLedCountFramesCount = function (numLeds, numFrames) {
    var frames = new Array(numFrames);
    var i;
    for (i = 0; i < numFrames; i++) {
        frames[i] = new Frame(numLeds);
    }
    return frames;
}
